/* Labyrinthe:
Version française de Big Adventure Marble Game
*/

/*Big Adventure Marble Maze Game
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 3 LEDs (red, yellow, green)
 * 3 220 Ohm resistors
 * 6 piezos
 * 6 10 MOhm resistors
 * push button

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.  
 */

// Les variables pour les broches
int brochesPoints[] = {A0, A1, A2, A3, A4};
int brochePoussoir = 7;
int LEDVerte = 4;
int LEDJaune = 5;
int LEDRouge = 6;

// La broche du haut-parleur
int brocheHautParleur = 9;

// Le nombre de capteurs pour le score
int nombrebrochesPoints = 5;

// Le seuil de déclenchement des capteurs piézoélectriques
int seuilPiezo = 800 ;

// Les variables des timers du jeu
int tempsMaximum = 10000;
long heureDeDepart;
boolean partieEnCours = false;

// Les variables de score
boolean nouveauScoreMaximum = false;
int scoreActuel = 0;
int scoreMaximum = 0;

// setup() s’exécute une fois quand la carte est alimentée
// ou après avoir appuyé sur le bouton Reset
void setup() {
  // Définition du mode de la broche du poussoir
  pinMode(brochePoussoir, INPUT_PULLUP);
  // Définition du mode des broches des LED
  pinMode(LEDVerte, OUTPUT);
  pinMode(LEDJaune, OUTPUT);
  pinMode(LEDRouge, OUTPUT);
  // Initialisation de la communication série
  Serial.begin(9600);
  // Commencer le compte à rebours avant le démarrage
  nouvellePartie();
}

// loop() s’exécute de façon continue après la fonction
// setup()
void loop() {
  // Si la partie est dans le temps imparti
  if( (millis() - heureDeDepart) < tempsMaximum) {
    // Lire les points de chaque broche
    int i;
    for( i=0; i<nombrebrochesPoints; i++ ) {
      int valeurBroche = analogRead(brochesPoints[i]);
      // Si la valeur ci-dessus est supérieure au seuil
      if( valeurBroche > seuilPiezo) {
        // Ajouter des points
        int nouveauxPoints = (i+1)*10 ;
        scoreActuel += nouveauxPoints ;
        // Afficher les points et le nouveau score
        Serial.print(" Points marqués ! ");
        Serial.print(nouveauxPoints);
        Serial.println(" points");
        Serial.print(" Score actuel : ");
        Serial.print(scoreActuel);
        Serial.println(" points");
        // Produire la tonalité sonore de marquage de points
        musiqueScore();
        // Pause évitant à la bille de marquer le score
        // plusieurs fois
        delay(300) ;
      }
    }
  }
  else{
    // sinon, si une partie est en cours
    // et que le temps limite est atteint
    if( partieEnCours) {
      // terminer la partie
      finPartie();
    }
    else{
      // sinon, vérifier si le poussoir est appuyé pour
      // débuter une partie
      int valeurPoussoir = digitalRead( brochePoussoir );
      if( valeurPoussoir == 0) {
        // Le bouton est appuyé, débuter une nouvelle partie
        nouvellePartie();
      }
      // Clignotement de la LED verte en cas de nouveau
      // record
      if( nouveauScoreMaximum ) {
        digitalWrite(LEDVerte, HIGH);
        delay(200);
        digitalWrite(LEDVerte, LOW);
        delay(200);
      }
      // Clignotement de la LED rouge si le drapeau est faux
      else {
        digitalWrite(LEDRouge, HIGH);
        delay(200);
        digitalWrite(LEDRouge, LOW);
        delay(200);
      }
    } 
  }
}

// Nouvelle partie :
// Définition des variables pour une nouvelle partie
// et du compte à rebours
void nouvellePartie() {
  // Assurer que les LED sont éteintes au départ
  digitalWrite(LEDRouge, LOW);
  digitalWrite(LEDJaune, LOW);
  digitalWrite(LEDVerte, LOW);
  Serial.println("****NOUVELLE PARTIE****");
  Serial.print("Début de la partie dans._._.");
  // Allumer la LED rouge
  digitalWrite(LEDRouge, HIGH);
  Serial.print("À vos marques._._.");
  delay(1000);
  // Éteindre la LED rouge
  digitalWrite(LEDRouge, LOW);
  // Allumer la LED jaune
  digitalWrite(LEDJaune, HIGH);
  Serial.print("prêt._._.");
  delay(1000);
  // Éteindre la LED jaune
  digitalWrite(LEDJaune, LOW);
  Serial.println("partez !");
  // Allumer la LED verte
  digitalWrite(LEDVerte, HIGH);
  // Émettre la mélodie de début de partie
  musiqueNouvellePartie();
  // Démarrer le timer de partie
  heureDeDepart = millis() ;
  // Drapeau de partie à vrai
  partieEnCours = true ;
  // Remise à zéro du score
  scoreActuel = 0;
}

// Fin de partie :
// Affichage des messages de fin de partie
// et vérification du score par rapport au score record
void finPartie() {
  Serial.println("Partie terminée !");
  Serial.print("Score : ");
  Serial.println(scoreActuel);
  // Positionner le drapeau partieEnCours pour indiquer
  // qu’il n’y a plus de partie en cours
  partieEnCours = false;
  if( scoreActuel > scoreMaximum ) {
    // Si c’est un nouveau record
    scoreMaximum = scoreActuel;
    Serial.println("Nouveau score record !");
    nouveauScoreMaximum = true;
    // Émettre la musique pour un record
    musiqueNouveauRecord() ;
    }
  else{
    // Sinon, si ce n’est pas un nouveau record
    nouveauScoreMaximum = false;
    // Émettre la musique de fin
    musiqueFinTriste() ;
  }
}

// Émettre la séquence sonore de marquage de points
void musiqueScore() {
  tone (brocheHautParleur, 659, 300) ;
  delay(300) ;
}

// Émettre la séquence sonore de début de partie
void musiqueNouvellePartie() {
  tone(brocheHautParleur, 523, 300);
  delay(300);
  tone(brocheHautParleur, 659, 300);
  delay(300);
  tone(brocheHautParleur, 784, 300);
  delay(300);
  tone(brocheHautParleur, 1047, 500);
  delay(600);
}

// Émettre la séquence sonore lors d‘un nouveau score record
void musiqueNouveauRecord() {
  tone(brocheHautParleur, 880, 300);
  delay(200);
  tone(brocheHautParleur, 440, 500);
  delay(200);
  tone(brocheHautParleur, 880, 300);
  delay(200);
  tone(brocheHautParleur, 440, 500);
  delay(200);
  tone(brocheHautParleur, 880, 300);
  delay(200);
  tone(brocheHautParleur, 440, 500);
  delay(200);
  tone(brocheHautParleur, 880, 300);
  delay(500);
}

// Émettre la séquence sonore de fin de partie
void musiqueFinTriste() {
  tone(brocheHautParleur, 698, 300);
  delay(300);
  tone(brocheHautParleur, 622, 300);
  delay(300);
  tone(brocheHautParleur, 587, 300);
  delay(300);
  tone(brocheHautParleur, 523, 500);
  delay(600);
}
